qui {

noi {
	/****************************************************************/
	/***** Step 2.9. Implications for historical independence waves */
	/****************************************************************/
}
	
	* STEP 1. Load trend-demeaned independence dividend estimates 
		
			* Get data
			cd ..
			cd ".\3. Intermediary results\3.4. Intermediaries"
			use total_file, clear
			cd ..
			cd ..
			
			* Add mother countries
			cd "./4. Master data"
			merge 1:m cntrycode independence_years using master_data, keepusing(mother_country_name)
			drop if _merge == 2
			drop _merge
			cd ..
			
			* Correct some mother country names
			replace mother_country_name = "Yugoslavia" if mother_country_name == "Montenegro" |  mother_country_name == "Serbia"
			replace mother_country_name = "South Africa" if mother_country_name == "Namibia"
			replace mother_country_name = "United States of America" if mother_country_name == "Palau"
			replace mother_country_name = "United Kingdom" if mother_country_name == "United Arab Emirates" |  mother_country_name == "Oman"
			replace mother_country_name = "Soviet Union" if cntry == "North Korea"
			
			* Plot results for each relevant mother country
			local count = 0
			noi di "Implications for historical independence waves:", _continue
			foreach mother in "Belgium" "Czechoslovakia" "France" "Portugal" "Russia" "United Kingdom" "United States of America" "Yugoslavia" {
				
				* Track progress
				local count = `count'+1
				noi di "`mother', ", _continue
				
				* Identify successor states & placebo samples
				gen mother_country = 1 if mother_country_name == "`mother'"
				levelsof cntrycode if mother_country_name == "`mother'", local(NICs)
				foreach cntry in `NICs' {
					local lower = `cntry'*1000
					local upper = `cntry'*1000 + 999
					replace mother_country = 1 if cntrycode >= `lower' & cntrycode <= `upper'
					}
				
				* Compute aggregate independence dividend
				preserve
				collapse (mean) bc_lgap  [w=popshare] if cntrycode < 400 & mother_country == 1, by(independence_years)
				gen iteration = 0	
				tempfile bs
				save `bs', emptyok
				restore
				
				* Add NIC-specific trajectories
				preserve
				keep if mother_country == 1 & cntrycode < 400
				keep cntrycode independence_years bc_lgap
				append using `bs', force
				save `bs', replace
				restore

				* Bootstrap placebo-estimates
				cd ".\3. Intermediary results\3.4. Intermediaries"
				foreach iteration of numlist 1/$firststepreps {
					noi di `iteration', _continue
					preserve
					sum cntrycode if independence_years == 0 & cntrycode < 400 & mother_country == 1
					bsample `r(N)' if cntrycode > 400  & mother_country == 1, cluster(cntrycode)
					collapse (mean) bc_lgap  [w=popshare], by(independence_years)
					gen iteration = `iteration'
					append using `bs', force
					save `bs', replace
					restore
					}
				
				* Get actual and bootstrapped placebo results
				preserve
				use `bs', clear
				sort iteration independence_years
				cd ..
				cd ..
				
				* Compute aggregate CI's
				gen PTTDIDD = bc_lgap if cntrycode != .
				gen PTTDDIDD_ll = .
				gen PTTDDIDD_ul = .
				gen PTTDDIDD_se = .

				foreach year of numlist -10/30 {
					sum bc_lgap if independence_years == `year' & iteration != 0 & cntrycode == .
					cap replace PTTDIDD = bc_lgap-`r(mean)' if independence_years == `year' & iteration == 0 & cntrycode == .
					cap replace PTTDIDD = bc_lgap-`r(mean)' if independence_years == `year' & cntrycode != .
					cap replace PTTDDIDD_ll = PTTDIDD+invttail((`r(N)'-1),.95)*`r(sd)' if independence_years == `year' & iteration == 0
					cap replace PTTDDIDD_ul = PTTDIDD+invttail((`r(N)'-1),.05)*`r(sd)' if independence_years == `year' & iteration == 0
					cap replace PTTDDIDD_se = `r(sd)' if independence_years == `year' & iteration == 0
					}
					
				cd  ".\3. Intermediary results"
				replace cntrycode = 99999+_n if cntrycode == .
				duplicates list cntrycode independence_years
				duplicates drop cntrycode independence_years PTTDIDD, force
				merge 1:1 cntrycode independence_years using IDD1_ci, keepusing(pvalue)
				replace cntrycode = . if cntrycode >= 99999
				drop if _merge == 2
				drop _merge
				cd ..
			
				* NIC-trajectories
				expand 2, gen(n)
				replace independence_years = independence_years-.5 if n == 1
				drop n
				sort cntrycode independence_years
				gen TDIDD_1 = PTTDIDD if pvalue > .1
				gen TDIDD_2 = PTTDIDD if pvalue <= .1 & pvalue > .05
				gen TDIDD_3 = PTTDIDD if pvalue <= .05 & pvalue > .01
				gen TDIDD_4 = PTTDIDD if pvalue <= .01
				sort cntrycode independence_years
				egen time = group(independence_years)
				replace time = _n if cntrycode == .
				
				duplicates drop cntrycode time, force
				xtset cntrycode time
				gen LPTTDIDD = L.PTTDIDD
				gen FPTTDIDD = F.PTTDIDD
				forval i=1/4 {
					gen helpme_`i' = TDIDD_`i'
					replace TDIDD_`i' = LPTTDIDD if helpme_`i' == . & F.helpme_`i' != .
					replace TDIDD_`i' = FPTTDIDD if helpme_`i' == . & L.helpme_`i' != .
					drop helpme_`i'
					}
				drop LPTTDIDD FPTTDIDD
				
				levelsof cntrycode, local(NICs)
				foreach i in `NICs' {
					local discrepancy_1  "`discrepancy_1' (line TDIDD_1 independence_years if cntrycode == `i', lc(gs15) cmiss(n))   || "
					local discrepancy_2  "`discrepancy_2' (line TDIDD_2 independence_years if cntrycode == `i' , lc(gs12) cmiss(n))  || "
					local discrepancy_3  "`discrepancy_3' (line TDIDD_3 independence_years if cntrycode == `i', lc(gs8) cmiss(n))  || "
					local discrepancy_4  "`discrepancy_4' (line TDIDD_4 independence_years if cntrycode == `i', lc(gs0) cmiss(n))  || "
					}
				
				* Plot aggregate independence dividend estimates + 95% CI
				keep if iteration == 0 | cntrycode != .
				sort iteration independence_years
				
				noi di ""
				noi list independence_years PTTDIDD PTTDDIDD_se if iteration == 0 & independence_years >= 0 & independence_years <= 30 & round(independence_years) == independence_years
				
				gen refline = 0
				sort cntrycode independence_years
				twoway 	`discrepancy_1' || ///
						`discrepancy_2' || ///
						`discrepancy_3' || ///
						`discrepancy_4' || ///
						(rline PTTDDIDD_ll PTTDDIDD_ul independence_years if iteration == 0, lstyle(ci) lcolor(edkblue) lpattern(longdash)) || ///
						(line refline independence_years if iteration == 0, lcolor(red)) || ///
						(connected PTTDIDD independence_years if iteration == 0, lcolor(gs0) mlcolor(gs0) mfcolor(gs0) msymbol(O)) || ///
						if independence_years >= 0 & independence_years <= 30 || ///
						, legend(off) ytitle("Independence dividend", size(large)) xtitle("Years of independence", size(large)) xline(0, lcolor(red) lpattern(dot) lstyle(foreground)) yline(0, lstyle(foreground) lcolor(gs0) lpattern(dot)) graphregion(color(white)) bgcolor(white) ///
						note("with 90% confidence interval")
				cd ".\5. TeX results"
				graph export figure11_`count'.pdf, replace
				cd ..
				restore
				
				* Drop unnecessary variables
				drop mother_country
				}
						
	* Reroute to directory containing dofiles
	cd ".\1. Dofiles"
	}
